<?php

/*
 * tnef_file.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  (c) 2003 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/tnef_file.php,v 1.2 2003/09/19 15:51:27 bernd Exp $
 *
 *   $Log: tnef_file.php,v $
 *   Revision 1.2  2003/09/19 15:51:27  bernd
 *   First working version of the compressed RTF decoder.
 *
 *   Revision 1.1  2003/07/31 15:24:25  bernd
 *   Complete rework of tnef decoder
 *
 *
 */

include_once(VIS_PATH_PLUGINS.'attachment_tnef/tnef_file_base.php');

class TnefFile extends TnefFileBase {
  var $metafile;

  function TnefFile($tnef_debug) {
    $this->TnefFileBase($tnef_debug);
  }

  function getMetafile() {
    return $this->metafile;
  }

  function receiveTnefAttribute($attribute, $value, $length) {
    switch ($attribute) {
    case TNEF_AFILENAME:                                        // filename
      $this->name = ereg_replace('.*[\/](.*)$', '\1', $value);
      break;

    case TNEF_ATTACHDATA:                                       // the attachment itself
      $this->content = $value;
      break;

    case TNEF_ATTACHMETAFILE:                                   // a metafile
      $this->metafile = $value;
      break;

    case TNEF_AATTACHCREATEDATE:
      $this->created = & new TnefDate;
      $this->created->setTnefBuffer($value);
      break;

    case TNEF_AATTACHMODDATE:
      $this->modified = & new TnefDate;
      $this->modified->setTnefBuffer($value);
      break;
    }
  }

  function receiveMapiAttribute($attr_type, $attr_name, $value, $length) {
    switch ($attr_name) {
    case TNEF_MAPI_ATTACH_LONG_FILENAME:                        // used in preference to AFILENAME value
      $val=ereg_replace('.*[\/](.*)$', '\1', $value);  // strip path
      if(!isset($this->name) || $this->name=='') $this->name = $val;
      break;

    case TNEF_MAPI_ATTACH_MIME_TAG:                             // Is this ever set, and what is format?
      $type0 = ereg_replace('^(.*)/.*', '\1', $value);
      $type1 = ereg_replace('.*/(.*)$', '\1', $value);
      $this->type = "$type0/$type1";
      break;

    case TNEF_MAPI_ATTACH_EXTENSION:
      $type = ext_to_mime($value);
      if ($type) {
	$this->type = $type;
      }
      break;
    }
  }
}

?>